<?php 
   /*
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreRisorsa {
        private $db;
        private $id;
        private $nome;
        private $categoria;
        private $descrizione;
        private $filtrabile;
        private $aTuttaLarghezza;
        private $senzaBordi; 
        private $classeElementi;

        public function __construct($db, $id, $nome="", $categoria=0, $descrizione="", $filtrabile="", $aTuttaLarghezza="", $senzaBordi="", $classeElementi="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->categoria = $categoria;
            $this->descrizione = $descrizione;
            $this->filtrabile = $filtrabile;
            $this->aTuttaLarghezza = $aTuttaLarghezza;
            $this->senzaBordi = $senzaBordi;
            $this->classeElementi = $classeElementi;
        }

        function crea() {
            $query = "INSERT INTO geec_visualizzatoriRisorse VALUES(NULL,'$this->nome','$this->categoria','$this->descrizione','$this->filtrabile','$this->aTuttaLarghezza','$this->senzaBordi','$this->classeElementi')";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        function modifica() {
            $query = "UPDATE geec_visualizzatoriRisorse SET nome='$this->nome', categoria='$this->categoria', descrizione='$this->descrizione', filtrabile='$this->filtrabile', aTuttaLarghezza='$this->aTuttaLarghezza', senzaBordi='$this->senzaBordi', classeElementi='$this->classeElementi' WHERE id=$this->id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_visualizzatoriRisorse",$this->id);
        }
        
        function duplica() {
            $query           = "INSERT INTO geec_visualizzatoriRisorse VALUES(NULL,'Copia di $this->nome','$this->categoria','$this->descrizione','$this->filtrabile','$this->aTuttaLarghezza','$this->senzaBordi','$this->classeElementi')";
            $idNuovoElemento = $this->db->eseguiQueryCreazione($query);
            return $idNuovoElemento;
        }
        
        function caricaDatiDalDatabase() {
            $datiVisualizzatore = $this->db->leggiSingolaRiga("geec_visualizzatoriRisorse",$this->id);
            $this->nome         = filter_var($datiVisualizzatore["nome"],FILTER_SANITIZE_ADD_SLASHES);
            $this->categoria    = $datiVisualizzatore["categoria"];
            $this->descrizione  = filter_var($datiVisualizzatore["descrizione"],FILTER_SANITIZE_ADD_SLASHES);
            $this->filtrabile   = $datiVisualizzatore["filtrabile"];
            $this->aTuttaLarghezza = $datiVisualizzatore["aTuttaLarghezza"];
            $this->senzaBordi      = $datiVisualizzatore["senzaBordi"];
            $this->classeElementi  = $datiVisualizzatore["classeElementi"];
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getCategoria() {
            return $this->categoria;
        }

        public function getDescrizione() {
            return $this->descrizione;
        }

        public function getFiltrabile() {
            return $this->filtrabile;
        }

        public function getATuttaLarghezza() {
            return $this->aTuttaLarghezza;
        }

        public function getSenzaBordi() {
            return $this->senzaBordi;
        }

        public function getClasseElementi() {
            return $this->classeElementi;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setCategoria($categoria) {
            $this->categoria = $categoria;
        }

        public function setDescrizione($descrizione) {
            $this->descrizione = $descrizione;
        }

        public function setFiltrabile($filtrabile) {
            $this->filtrabile = $filtrabile;
        }

        public function setATuttaLarghezza($aTuttaLarghezza) {
            $this->aTuttaLarghezza = $aTuttaLarghezza;
        }

        public function setSenzaBordi($senzaBordi) {
            $this->senzaBordi = $senzaBordi;
        }

        public function setClasseElementi($classeElementi) {
            $this->classeElementi = $classeElementi;
        }

    }